 ; Ŀ
 ;   Hose - Replace solids with hatches.                                   
 ;   Copyright 2001 by Rocket Software Ltd.                                
 ;   For Rocket internal use only - do not release.                        
 ; 

 ; Ŀ
 ;   Herro - error handler.                                                
 ; 
 (DEFUN HERRO (shk / pos entt enam sublst vall)
  (setq *error* esav)
  (if clay (setvar "clayer" clay))
  (if (/= shk "Function cancelled") (write-line shk))
 (princ))
 ; Ŀ
 ;   Herro end.                                                            
 ; 

 ; Ŀ
 ;   Hatcher - hatch a selection set.                                      
 ;   Arguments: ss -  a selection set of objects to hatch.                 
 ;              Name - the hatch pattern name.                             
 ; 
 (DEFUN HATCHER (ss name / hasc clay)
  (setq hasc (* (getvar "dimscale") 5.0))
  (setq clay (getvar "clayer"))
  (setvar "clayer" "0")
  (command "bhatch" "p" name hasc "0" "select" ss "" "")
  (setvar "clayer" clay)
 (princ))
 ; Ŀ
 ;   Hatche end.                                                           
 ; 

 ; Ŀ
 ;   Hose.                                                                 
 ; 
 (DEFUN C:HOSE (/ esav ss num entt pt1 pt2 pt3 pt4)
  (setvar "cmdecho" 0)
  (setq esav *error*)
  (setq *error* herro)
  (setq ss (ssget (list (cons 0 "solid"))))
  (setq num 0)
  (while (and ss (setq enam (ssname ss num)))
         (setq num (1+ num))
         (setq entt (entget enam))
         (setq pt1 (cdr (assoc 10 entt)))
         (setq pt2 (cdr (assoc 11 entt)))
         (setq pt3 (cdr (assoc 12 entt)))
         (setq pt4 (cdr (assoc 13 entt)))
         (if (equal pt3 pt4 0.00000001)
             (command ".pline" pt1 pt2 pt3 "close")
             (command ".pline" pt1 pt2 pt4 pt3 "close"))
         (entdel enam)
         (hatcher (entlast) "dots"))
  (setq *error* esav)
 (princ))